import javax.media.j3d.*;
import javax.vecmath.*; 
import java.awt.*;
import java.awt.event.*;
import com.sun.j3d.utils.geometry.*;
import com.sun.j3d.utils.behaviors.keyboard.*;
/**
 * This uses three resolutions of a cylinder to demonstrate
 * the operation of a level of detail node.
 * @author I.J.Palmer
 * @version 1.0
 */
public class SimpleLOD extends Frame implements ActionListener {
	protected Canvas3D myCanvas3D = new Canvas3D(null);
	protected Button exitButton = new Button("Exit");
    protected BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
	/** 
	 * Build the view branch of the scene graph.  In this case
	 * a key navigation utility object is created and associated
	 * with the view transform so that the view can be changed
	 * via the keyboard.
	 * @return BranchGroup that is the root of the view branch
	 */
	protected BranchGroup buildViewBranch(Canvas3D c) {
		BranchGroup viewBranch = new BranchGroup();
		Transform3D viewXfm = new Transform3D();
            	viewXfm.set(new Vector3f(0.0f,0.0f,10.0f));
		TransformGroup viewXfmGroup = new TransformGroup(viewXfm);
		viewXfmGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		viewXfmGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		BoundingSphere movingBounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
		BoundingLeaf boundLeaf = new BoundingLeaf(movingBounds);
		ViewPlatform myViewPlatform = new ViewPlatform();
		viewXfmGroup.addChild(boundLeaf);
            	PhysicalBody myBody = new PhysicalBody();
            	PhysicalEnvironment myEnvironment = new PhysicalEnvironment();
		viewXfmGroup.addChild(myViewPlatform);
		viewBranch.addChild(viewXfmGroup);
		View myView = new View();
		myView.addCanvas3D(c);
		myView.attachViewPlatform(myViewPlatform);
            	myView.setPhysicalBody(myBody);
            	myView.setPhysicalEnvironment(myEnvironment);
		
		KeyNavigatorBehavior keyNav = new KeyNavigatorBehavior(viewXfmGroup);
		keyNav.setSchedulingBounds(movingBounds);
		viewBranch.addChild(keyNav);

		return viewBranch;
	}
      /** 
       * Add some lights to the scene graph 
       * @param b BranchGroup that the lights are added to
       */
      protected void addLights(BranchGroup b) {
		Color3f ambLightColour = new Color3f(0.5f, 0.5f, 0.5f);
		AmbientLight ambLight = new AmbientLight(ambLightColour);
            	ambLight.setInfluencingBounds(bounds);
            	Color3f dirLightColour = new Color3f(1.0f, 1.0f, 1.0f);
            	Vector3f dirLightDir  = new Vector3f(-1.0f, -1.0f, -1.0f);
            	DirectionalLight dirLight = new DirectionalLight(dirLightColour, dirLightDir);
            	dirLight.setInfluencingBounds(bounds);
		b.addChild(ambLight);
            	b.addChild(dirLight);
      }
      /** 
       * Build the content branch for the scene graph
       * This creates three cylinders, each with a different
       * resolution.  These are then used with a LOD node
       * to implement a crude level of detail.
       * @return BranchGroup that is the root of the content
       */
      protected BranchGroup buildContentBranch() {
		//Create the appearance
		Appearance app = new Appearance();
		Color3f ambientColour = new Color3f(1.0f,1.0f,0.0f);
            	Color3f emissiveColour = new Color3f(0.0f,0.0f,0.0f);
		Color3f specularColour = new Color3f(1.0f,1.0f,1.0f);
		Color3f diffuseColour = new Color3f(1.0f,1.0f,0.0f);
            	float shininess = 20.0f;
		app.setMaterial(new Material(ambientColour, emissiveColour,
				diffuseColour,specularColour,shininess));
		//Make the switch node that is to used with the LOD
		//and make it writable
		Switch LODswitch = new Switch();
		LODswitch.setCapability(Switch.ALLOW_SWITCH_WRITE);
		//Add the three cylinders
		LODswitch.addChild(new Cylinder(1.0f,1.0f,Cylinder.GENERATE_NORMALS,
		10,10,app));
		LODswitch.addChild(new Cylinder(1.0f,1.0f,Cylinder.GENERATE_NORMALS,
		5,5,app));
		LODswitch.addChild(new Cylinder(1.0f,1.0f,Cylinder.GENERATE_NORMALS,
		3,3,app));
		//Define the distances for the LOD
		float[] LODdistances = {5.0f,10.0f,15.0f};
		DistanceLOD myLOD = new DistanceLOD(LODdistances,new Point3f(0.0f,0.0f,0.0f));
		myLOD.setSchedulingBounds(bounds);
		//Add the switch to the LOD
		myLOD.addSwitch(LODswitch);
		BranchGroup contentBranch = new BranchGroup();
		contentBranch.addChild(myLOD);
            	addLights(contentBranch);

		contentBranch.addChild(LODswitch);
		return contentBranch;

      	} 
      /** 
       * Use the action event of the exit button
       * to end the application.
       */
	public void actionPerformed(ActionEvent e) {
			dispose();
                	System.exit(0);
	}
        public SimpleLOD() {
		VirtualUniverse myUniverse = new VirtualUniverse();
		Locale myLocale = new Locale(myUniverse);
                myLocale.addBranchGraph(buildViewBranch(myCanvas3D));
                myLocale.addBranchGraph(buildContentBranch());
		setTitle("SimpleLOD");
		setSize(400,400);
		setLayout(new BorderLayout());
		Panel bottom = new Panel();
		bottom.add(exitButton);
                add(BorderLayout.CENTER, myCanvas3D);
                add(BorderLayout.SOUTH, bottom);
                exitButton.addActionListener(this);
                setVisible(true);
	}
	public static void main(String[] args) {
                  SimpleLOD sl = new SimpleLOD();
	}
}

